/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.transaction;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.ITransaction;
import dev.toma.gunsrpg.api.common.ITransactionType;
import dev.toma.gunsrpg.api.common.data.ITransactionManager;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TransactionManager
implements ITransactionManager {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Transactions");
    private final Map<ITransactionType<?>, ITransactionHandler<?>> handlerMap = new IdentityHashMap();

    @Override
    public <T> void registerHandler(ITransactionType<T> type, final ITransactionManager.ITransactionPredicate<T> fundChecker, final ITransactionManager.ITransactionConsumer<T> handler) {
        this.handlerMap.put(type, new ITransactionHandler<T>(){

            @Override
            public boolean hasFunds(ITransaction<T> transaction) {
                return fundChecker.hasFundsForTransaction(transaction);
            }

            @Override
            public void handle(ITransaction<T> transaction) {
                handler.processTransaction(transaction);
            }
        });
    }

    @Override
    public <T> boolean hasFunds(ITransaction<T> transaction) {
        ITransactionHandler<T> handler = this.getHandler(transaction.getType());
        return handler != null && handler.hasFunds(transaction);
    }

    @Override
    public <T> void handleTransaction(ITransaction<T> transaction) {
        ITransactionHandler<T> handler = this.getHandler(transaction.getType());
        if (handler != null) {
            handler.handle(transaction);
        } else {
            GunsRPG.log.fatal(MARKER, "Received invalid transaction [Transaction=(amount={}, data={})]", (Object)transaction.total(), transaction.getData());
        }
    }

    private <T> ITransactionHandler<T> getHandler(ITransactionType<T> type) {
        return this.handlerMap.get(type);
    }

    public static interface ITransactionHandler<T> {
        public boolean hasFunds(ITransaction<T> var1);

        public void handle(ITransaction<T> var1);
    }
}

